/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.application;

import cz.vity.freerapid.utilities.LogUtils;
import java.awt.Desktop;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.logging.Logger;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;

class EmailErrorReporter
implements ErrorReporter {
    private static final Logger logger = Logger.getLogger(EmailErrorReporter.class.getName());
    private static final String MAIL_FOR_ERRORS = "info@wordrider.net";

    EmailErrorReporter() {
    }

    @Override
    public void reportError(ErrorInfo info) throws NullPointerException {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        String mailbody = String.format("Basic Error message:%s%nCategory:%sState:%s%nException:%s%n", info.getBasicErrorMessage(), info.getCategory(), EmailErrorReporter.mapToString(info.getState()), info.getErrorException().toString());
        mailbody = EmailErrorReporter.encode(mailbody);
        String mail = String.format("mailto:%s?subject=%s&body=%s", MAIL_FOR_ERRORS, EmailErrorReporter.encode("ERModeller Error report"), mailbody);
        try {
            desktop.mail(new URI(mail));
        }
        catch (IOException e) {
            LogUtils.processException(logger, e);
        }
        catch (URISyntaxException e) {
            LogUtils.processException(logger, e);
        }
    }

    private static String encode(String text) {
        try {
            return URLEncoder.encode(text, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            LogUtils.processException(logger, e);
            return "";
        }
    }

    private static String mapToString(Map<String, String> state) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : state.entrySet()) {
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
            builder.append('\n');
        }
        return builder.toString();
    }
}

